﻿using System;

public class SiteManager
{
    SiteList sites = new SiteList();

    public SiteManager()
    {
        this.sites[this.sites.NextIndex]
            = new WebSite("Jurek",
                          "http://www.mysite.com",
                          "Super strona!");
        this.sites[this.sites.NextIndex]
            = new WebSite("Darek",
                          "http://www.darekdotnet.com",
                          "W porządku.");
        this.sites[this.sites.NextIndex]
            = new WebSite("Robert",
                          "www.robert.com",
                          "Brak http://");
    }

    public void AddSite()
    {
        string siteName;
        string url;
        string description;

        Console.Write("Podaj nazwę strony: ");
        siteName = Console.ReadLine();

        Console.Write("Wprowadź URL: ");
        url = Console.ReadLine();

        Console.Write("Wprowadź opis: ");
        description = Console.ReadLine();

        sites[sites.NextIndex] = new WebSite(siteName,
                                             url,
                                             description);
    }

    public void DeleteSite()
    {
        string choice;

        do
        {
            Console.WriteLine("\nMenu usuwania\n");
            DisplayShortList();

            Console.Write("\nWybierz element do usunięcia:  ");
            choice = Console.ReadLine();

            if (choice == "W" || choice == "w")
                break;

            if (Int32.Parse(choice) <= sites.NextIndex)
                sites.Remove(Int32.Parse(choice) - 1);

        } while (true);
    }

    public void ModifySite()
    {
        Console.WriteLine("Modyfikacja stron.");
    }

    public void ViewSites()
    {
        Console.WriteLine("");

        for (int i = 0; i < sites.NextIndex; i++)
        {
            Console.WriteLine("Strona: {0}", sites[i].ToString());
        }

        Console.WriteLine("");
    }

    private void DisplayShortList()
    {
        for (int i = 0; i < sites.NextIndex; i++)
        {
            Console.WriteLine("{0} - {1}", i + 1, sites[i].ToString());
        }

        Console.WriteLine("W - Wyjście (do menu głównego)");
    }
}
